from flask import Flask
from pymongo import MongoClient
 
 
def register_blueprints(app):
    from app.api.v1 import create_blueprint_v1
    app.register_blueprint(create_blueprint_v1(), url_prefix='/v1')
 
 
def create_app():
    app = Flask(__name__)
    app.config.from_object('app.config.setting')
    app.config.from_object('app.config.secure')
	
	# 初始化MongoDB连接
	app.db = MongoClient(app.config['MONGO_URI']).get_database(app.config['MONGO_DBNAME'])
	
    # 将蓝图注册到app 上
    register_blueprints(app)
    return app