// utils/storage.js

// 存储 JWT 信息到本地存储
export function storeJwtInfo2User(jwt) {
	if (jwt) {
		const jwtParts = jwt.split('.');
		if (jwtParts.length === 3) {
			const decodedJwt = JSON.parse(atob(jwtParts[1]));
			const user = {
				userId: decodedJwt.sub,
				username: decodedJwt.username,
				email: decodedJwt.email,
				avatar: decodedJwt.avatar_url,
				bio: decodedJwt.bio
			};
			uni.setStorageSync('userInfo', user);
		}
	} else {
		uni.setStorageSync('userInfo', {});
	}
}
